/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.HashMap;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.ClientPlayerMovement;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.RemotePlayerMovement;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.ModStructures;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncParaglidingMsg;

@Mod.EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private static final double DEFAULT_PARAGLIDING_SPEED = 0.02599999986588955;
    private static final ResourceLocation MOVEMENT_HANDLER_KEY = new ResourceLocation("paraglider", "paragliding_movement_handler");

    private ParagliderEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void loadBiome(BiomeLoadingEvent event) {
        switch (event.getCategory()) {
            case EXTREME_HILLS: 
            case MESA: 
            case PLAINS: 
            case SAVANNA: {
                event.getGeneration().getStructures().add(() -> ModStructures.TARREY_TOWN_GODDESS_STATUE_CONFIGURED);
            }
            case NONE: 
            case TAIGA: 
            case FOREST: 
            case JUNGLE: 
            case ICY: 
            case BEACH: 
            case DESERT: 
            case RIVER: 
            case MUSHROOM: {
                event.getGeneration().getStructures().add(() -> ModStructures.UNDERGROUND_HORNED_STATUE_CONFIGURED);
                break;
            }
            case NETHER: {
                ResourceLocation name = event.getName();
                if (name != null && (name.equals((Object)Biomes.field_235251_aB_.func_240901_a_()) || name.equals((Object)Biomes.field_235253_az_.func_240901_a_()))) break;
                event.getGeneration().getStructures().add(() -> ModStructures.NETHER_HORNED_STATUE_CONFIGURED);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && world.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(world.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
        if (ModCfg.enableStructures()) {
            tempMap.put(ModStructures.UNDERGROUND_HORNED_STATUE, ModStructures.UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS);
            tempMap.put(ModStructures.NETHER_HORNED_STATUE, ModStructures.NETHER_HORNED_STATUE_SEPARATION_SETTINGS);
            tempMap.put(ModStructures.TARREY_TOWN_GODDESS_STATUE, ModStructures.TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS);
        } else {
            tempMap.remove((Object)ModStructures.UNDERGROUND_HORNED_STATUE);
            tempMap.remove((Object)ModStructures.NETHER_HORNED_STATUE);
            tempMap.remove((Object)ModStructures.TARREY_TOWN_GODDESS_STATUE);
        }
        world.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        ServerPlayerMovement m;
        if (event.isCancelable() && event.getHand() == Hand.OFF_HAND && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer())) != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        PlayerMovement m1 = PlayerMovement.of((ICapabilityProvider)event.getOriginal());
        PlayerMovement m2 = PlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (m1 != null && m2 != null) {
            m1.copyTo(m2);
        }
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Tick event) {
        ServerPlayerMovement m;
        if (event.getEntityLiving().func_184600_cs() == Hand.OFF_HAND && event.getEntityLiving() instanceof PlayerEntity && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getEntityLiving())) != null && m.isParagliding()) {
            event.getEntityLiving().func_184602_cy();
        }
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity o = (Entity)event.getObject();
        if (o instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)o;
            PlayerMovement m = p instanceof ServerPlayerEntity ? new ServerPlayerMovement((ServerPlayerEntity)p) : (PlayerMovement)DistExecutor.unsafeRunForDist(() -> () -> Client.createPlayerMovement(p), () -> () -> new RemotePlayerMovement(p));
            event.addCapability(MOVEMENT_HANDLER_KEY, (ICapabilityProvider)m);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerMovement h = PlayerMovement.of((ICapabilityProvider)event.player);
        if (h != null) {
            if (event.phase == TickEvent.Phase.END) {
                h.update();
            } else if (h.isParagliding()) {
                double v = ModCfg.paraglidingSpeed();
                event.player.field_70747_aH = (float)(0.02599999986588955 * v);
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerMovement h = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (h != null) {
            h.movementNeedsSync = true;
            h.paraglidingNeedsSync = true;
            h.vesselNeedsSync = true;
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        PlayerMovement h;
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && (h = PlayerMovement.of((ICapabilityProvider)event.getTarget())) != null) {
            SyncParaglidingMsg msg = new SyncParaglidingMsg(h);
            if (ModCfg.traceParaglidingPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} from player {} to player {}", (Object)msg, (Object)h.player, (Object)player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)msg);
        }
    }

    private static final class Client {
        private Client() {
        }

        public static PlayerMovement createPlayerMovement(PlayerEntity player) {
            return player instanceof ClientPlayerEntity ? new ClientPlayerMovement(player) : new RemotePlayerMovement(player);
        }
    }
}

